import { Module } from '@nestjs/common';
import { BusinessEmailService } from './business-email.service';
import { BusinessEmailController } from './business-email.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { BusinessEmail } from './entities/business-email.entity';

@Module({
  imports: [TypeOrmModule.forFeature([BusinessEmail]), AuthModule],
  controllers: [BusinessEmailController],
  providers: [BusinessEmailService],
  exports: [BusinessEmailService],
})
export class BusinessEmailModule {}
