import { IsBoolean, IsOptional } from 'class-validator';
import { Transform } from 'class-transformer';

export class UpdateBusinessEmailDto {
  @IsOptional()
  mailEngine: string;

  @IsOptional()
  smtpHost: string;

  @IsOptional()
  smtpPort: string;

  @IsOptional()
  username: string;

  @IsOptional()
  password: string;

  @IsOptional()
  from: string;

  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  secure: number;
}
