import { Type } from 'class-transformer';
import {
  IsDate,
  IsEAN,
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { MasterPaymentMode } from 'src/enum';

export class CreateBusinessPaymentRecordDto {
  @IsNotEmpty()
  transactionId: string;

  @IsNotEmpty()
  subject: string;

  @IsOptional()
  invoiceNumber: string;

  @IsOptional()
  businessName: string;

  @IsNotEmpty()
  accountId: string;

  @IsNotEmpty()
  @Type(() => Number)
  subTotal: number;

  @IsOptional()
  total: number;

  @IsNotEmpty()
  @Type(() => Number)
  paid: number;

  @IsOptional()
  amountDue: number;

  @IsNotEmpty()
  @IsEnum(MasterPaymentMode)
  paymentMode: MasterPaymentMode;

  @IsNotEmpty()
  paymentDate: Date;

  @IsOptional()
  note: string;
}

export class RecordPaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  paymentMode: MasterPaymentMode;

  @IsOptional()
  fromDate: string;

  @IsOptional()
  toDate: string;

  @IsOptional()
  accountId: string;
}
