import { Account } from 'src/account/entities/account.entity';
import { DefaultStatus } from 'src/enum';
import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';

@Entity()
export class BusinessPayment {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  keyId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  keySecret: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  gatewayName: string;

  @Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.ACTIVE })
  status: DefaultStatus;

  @ManyToOne(() => Account, (account) => account.businessPayment, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];
}
