import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
// import { NodeMailerModule } from "src/node-mailer/node-mailer.module";
import { PaymentHistory } from './entities/payment-history.entity';
import { PaymentHistoryController } from './payment-history.controller';
import { PaymentHistoryService } from './payment-history.service';
import { NotifyModule } from 'src/notify/notify.module';
import { BusinessPayment } from 'src/business-payment/entities/business-payment.entity';
import { UserDetail } from 'src/user-details/entities/user-detail.entity';
import { MembershipCard } from 'src/membership-card/entities/membership-card.entity';
import { NodeMailerModule } from 'src/node-mailer/node-mailer.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([PaymentHistory, BusinessPayment, UserDetail, MembershipCard]),
    AuthModule,
    NodeMailerModule,
    NotifyModule,
  ],
  controllers: [PaymentHistoryController],
  providers: [PaymentHistoryService],
  exports: [PaymentHistoryService],
})
export class PaymentHistoryModule {}
