import { Account } from 'src/account/entities/account.entity';
import { ChildLog } from 'src/child-log/entities/child-log.entity';
import { UserDetail } from 'src/user-details/entities/user-detail.entity';
import { UserLog } from 'src/user-log/entities/user-log.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class UserChild {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'uuid', nullable: true })
  businessAccId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  memberId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  oldDepMemberId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  childCardNumber: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  name: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  email: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  phoneNumber: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  relation: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  martialStatus: string;

  @Column({ type: 'date', nullable: true })
  dob: string;

  @Column({ type: 'text', nullable: true })
  profile: string;

  @Column({ type: 'text', nullable: true })
  profilePath: string;

  @Column({ type: 'text', nullable: true })
  doc: string;

  @Column({ type: 'text', nullable: true })
  docPath: string;

  @CreateDateColumn()
  createAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Account, (account) => account.userChild, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => Account, (account) => account.userChild, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  businessAcc: Account[];

  @OneToMany(() => ChildLog, (childLog) => childLog.userChild)
  childLog: ChildLog[];
}
