import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { AccountController } from './account.controller';
import { AccountService } from './account.service';
import { Account } from './entities/account.entity';
import { Notification } from '../notifications/entities/notification.entity';
import { NotificationsModule } from '../notifications/notifications.module';
import { UserDetail } from '../user-details/entities/user-detail.entity';
import { MenusModule } from 'src/menus/menus.module';
import { PermissionsModule } from 'src/permissions/permissions.module';
import { UserPermissionsModule } from 'src/user-permissions/user-permissions.module';
import { StaffDetail } from 'src/staff_detail/entities/staff_detail.entity';
import { StaffDetailModule } from 'src/staff_detail/staff_detail.module';
import { NodeMailerModule } from 'src/node-mailer/node-mailer.module';


@Module({
  imports: [
    TypeOrmModule.forFeature([Account, UserDetail,StaffDetail]),
    AuthModule, NotificationsModule,MenusModule,
    PermissionsModule,
    UserPermissionsModule,
    StaffDetailModule,
    NodeMailerModule
  ],
  controllers: [AccountController],
  providers: [AccountService],
  exports: [AccountService],
})
export class AccountModule { }
