import { IsOptional, IsString, IsInt, Min, IsNotEmpty, MinLength, MaxLength, IsEmail, IsEnum } from 'class-validator';
import { Type } from 'class-transformer';
import { DefaultStatus, UserRole } from 'src/enum';

export class PaginationDto {
	@IsOptional()
	@Type(() => Number)
	@IsInt()
	@Min(0)
	offset: number;

	@IsOptional()
	@Type(() => Number)
	@IsInt()
	@Min(1)
	limit: number;

	@IsOptional()
	@IsString()
	keyword: string;

  @IsOptional()
  @IsString()
  loginId: string;

	@IsOptional()
	@IsString()
	status: DefaultStatus;
}
export class CreateAccountDto {
  // @IsNotEmpty()
  // @IsString()
  // @MinLength(5)
  // @MaxLength(100)
  // loginId: string;
 @IsString()
  @IsOptional()
  name: string;

  @IsNotEmpty()
  @MinLength(10)
  @MaxLength(14)
  phoneNumber: string;

  @IsNotEmpty()
  @IsString()
  @MinLength(5)
  @MaxLength(100)
  password: string;
  
  @IsEmail()
 @IsOptional()
  email: string; 

  @IsString()
   @IsOptional()
  address: string;

  @IsNotEmpty()
  @IsEnum(UserRole)
  roles: UserRole;
}