import { IsEmail, IsEnum, IsNotEmpty, IsOptional, IsString } from 'class-validator';
import { UserRole, DefaultStatus } from 'src/enum';

export class AdminCreateUserDto {
  @IsString()
  @IsNotEmpty()
  name: string;

  @IsEmail()
  email: string;

  @IsString()
  @IsNotEmpty()
  phoneNumber: string;

  @IsString()
  @IsNotEmpty()
  address: string;

  @IsEnum(UserRole)
  @IsNotEmpty()
  role: UserRole;

  @IsEnum(DefaultStatus)
  @IsOptional()
  status: DefaultStatus = DefaultStatus.ACTIVE;

  @IsString()
  @IsOptional()
  businessName?: string;
}