import { IsEmail, IsEnum, IsNotEmpty, IsOptional, IsString } from 'class-validator';
import { UserRole, DefaultStatus } from 'src/enum';

export class CreateUserByAdminDto {
  @IsString()
  @IsNotEmpty()
  phoneNumber: string;

  @IsEnum(UserRole)
  @IsNotEmpty()
  role: UserRole;

  @IsEnum(DefaultStatus)
  @IsOptional()
  status: DefaultStatus = DefaultStatus.ACTIVE;

  @IsString()
  @IsOptional()
  name: string;

  @IsEmail()
  @IsOptional()
  email: string;

  @IsString()
  @IsOptional()
  address: string;

  @IsString()
  @IsOptional()
  businessName: string;

  @IsString()
  @IsOptional()
  alternativePhoneNumber: string;
}