
import { UserDetail } from 'src/user-details/entities/user-detail.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';
import { DefaultStatus, UserRole } from '../../enum';
import { Notification } from '../../notifications/entities/notification.entity';
import { Wishlist } from 'src/wishlist/entities/wishlist.entity';
import { RatingFeedback } from 'src/rating-feedback/entities/rating-feedback.entity';
import { CartItem } from 'src/cart-item/entities/cart-item.entity';
import { Cart } from 'src/cart/entities/cart.entity';
import { Order } from 'src/order/entities/order.entity';
import { deliveryAddress } from '../../delivery-address/entities/delivery-address.entity';
import { StaffDetail } from 'src/staff_detail/entities/staff_detail.entity';
import { UserPermission } from 'src/user-permissions/entities/user-permission.entity';

@Entity()
export class Account {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  phoneNumber: string;

  @Column({ type: 'text', nullable: true })
  password: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  deviceId: string;

  @Column({ type: 'uuid', nullable: true })
  createdBy: string;

  @Column({ type: 'enum', enum: UserRole, default: UserRole.USER })
  roles: UserRole;

  @Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.ACTIVE })
  status: DefaultStatus;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @OneToMany(() => Notification, (notification) => notification.account)
  notification: Notification[];

  @OneToMany(() => UserDetail, (userDetail) => userDetail.account)
  userDetail: UserDetail[];
  @OneToMany(() => Wishlist, (wishlist) => wishlist.account)
  wishlist: Wishlist[];

  @OneToMany(() => RatingFeedback, (ratingFeedback) => ratingFeedback.account)
  ratingFeedback: RatingFeedback[];



  @OneToMany(() => Cart, (cart) => cart.account)
  cart: Cart[];

  @OneToMany(() => CartItem, (cartItems) => cartItems.account, {
    cascade: true,
  })
  cartItems: CartItem[];

  @OneToMany(() => Order, (order) => order.account, { cascade: true })
  order: Order[];

  @OneToMany(() => deliveryAddress, (deliveryDetail) => deliveryDetail.account)
  deliveryDetail: deliveryAddress[];

  @OneToMany(() => StaffDetail, (staffDetail) => staffDetail.account)
  staffDetail: StaffDetail[];
  
  @OneToMany(() => UserPermission, (userPermission) => userPermission.account)
  userPermission: UserPermission[];


}
