import { CacheModule } from '@nestjs/cache-manager';
import { flatten, Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ServeStaticModule } from '@nestjs/serve-static';
import { join } from 'path';
import { AccountModule } from './account/account.module';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { AuthModule } from './auth/auth.module';
import { BannerModule } from './banner/banner.module';
import { NotificationsModule } from './notifications/notifications.module';
import { ProductModule } from './product/product.module';
import { BrandModule } from './brand/brand.module';
import { CartModule } from './cart/cart.module';
import { Category } from './category/entities/category.entity';
import { CategoryModule } from './category/category.module';
import { UserDetailsModule } from './user-details/user-details.module';
import { ProductImagesModule } from './product-images/product-images.module';
import { WishlistModule } from './wishlist/wishlist.module';
import { ContactUsModule } from './contact-us/contact-us.module';
import { RatingFeedbackModule } from './rating-feedback/rating-feedback.module';
import { CartItemModule } from './cart-item/cart-item.module';
import { OrderModule } from './order/order.module';
import { OrderItemModule } from './order-item/order-item.module';
import { CityModule } from './city/city.module';
import { StateModule } from './state/state.module';
import { PagesModule } from './pages/pages.module';
import { CouponModule } from './coupon/coupon.module';
import { DeliveryAddressModule } from './delivery-address/delivery-address.module';
import { DashboardModule } from './dashboard/dashboard.module';
import { SettingsModule } from './settings/settings.module';
import { StaffDetailModule } from './staff_detail/staff_detail.module';
import { UserPermissionsModule } from './user-permissions/user-permissions.module';
import { PermissionsModule } from './permissions/permissions.module';
import { MenusModule } from './menus/menus.module';
import { NodeMailerModule } from './node-mailer/node-mailer.module';
import * as bcrypt from 'bcrypt';


@Module({
  imports: [
    ConfigModule.forRoot(),
    ServeStaticModule.forRoot({
      rootPath: join(__dirname, '..', 'uploads'),
      serveRoot: '/uploads',
    }),
    TypeOrmModule.forRoot({
      type: 'mysql',
      host: process.env.RN_DB_HOST,
      port: Number(process.env.RN_DB_PORT),
      username: process.env.RN_USER_NAME,
      password: process.env.RN_DB_PASS,
      database: process.env.RN_DB_NAME,
      entities: [__dirname + '/**/*.entity{.ts,.js}'],
      synchronize:false, 
      }),
    CacheModule.register({
      isGlobal: true,
    }),

    AuthModule,
    AccountModule,
    BannerModule,
    NotificationsModule,
    ProductModule,
    BrandModule,
    CartModule,
    CategoryModule,
    UserDetailsModule,
    ProductImagesModule,
    WishlistModule,
    ContactUsModule,
    DeliveryAddressModule,
    RatingFeedbackModule,
    CartItemModule,
    OrderItemModule,
    OrderModule,
    CityModule,
    StateModule,
    PagesModule,
    CouponModule,
    DashboardModule,
    SettingsModule,
    StaffDetailModule,
    UserPermissionsModule,
    PermissionsModule,
    MenusModule,
    NodeMailerModule,

  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule { }
