import { Type } from 'class-transformer';
import { IsEnum, IsNotEmpty, IsNumber, IsOptional, IsString, IsUrl, MaxLength, MinLength } from 'class-validator';
import { UserRole } from '../../enum';


export class LoginRequestDto {
  @IsNotEmpty()
  phoneNumber: string;

  @IsEnum(UserRole)
  role: UserRole;
}

export class VerifyLoginOtpDto {
  @IsNotEmpty()
  phoneNumber: string;

  @IsString()
  otp: string;

  @IsEnum(UserRole)
  role: UserRole;
}
export class AdminSigninDto {
  @IsNotEmpty()
  loginId: string;

  @IsOptional()
  password: string
}
export class ForgotPassDto {
  @IsOptional()
  @MinLength(0)
  @MaxLength(50)
  phoneNumber: string;

  @IsOptional()
  newPassword: string;
}
