import { IsEmail, IsEnum, IsNotEmpty, IsNumber, IsPhoneNumber, IsString } from 'class-validator';
import { UserRole } from '../../enum';

export class SendOtpDto {
  @IsString()
  phoneNumber: string;
}


export class VerifyOtpDto {
  @IsNotEmpty()
  phoneNumber: string;

  @IsString()
  otp: string;
}

export class RegisterUserDto {
  @IsNotEmpty()
  name: string;

  @IsEmail()
  email: string;

  @IsNotEmpty()
  phoneNumber: string;

  @IsNotEmpty()
  address: string;
}

export class RegisterRetailerDto {
  @IsNotEmpty()
  name: string;

  @IsEmail()
  email: string;

  @IsNotEmpty()
  businessName: string;

  @IsNotEmpty()
  phoneNumber: string;

  @IsNotEmpty()
  address: string;
}
