import { Type } from 'class-transformer';
import { IsEnum, IsNotEmpty, IsNumber, IsOptional, IsString, Max, MaxLength, Min, MinLength } from "class-validator";
import { DefaultStatus, ProductStatus, UserRole } from '../../enum';

export class CreateBrandDto {
	@IsNotEmpty()
	// @IsString()
	name: string;
}

export class PaginationDto {
	@IsOptional()
	@Type(() => Number)
	@IsNumber()
	@Min(1)
	@Max(100)
	limit: number;

	@IsOptional()
	@Type(() => Number)
	@IsNumber()
	@Min(0)
	offset: number;

	@IsOptional()
	@IsString()
	@MinLength(0)
	@MaxLength(100)
	keyword: string;

	@IsOptional()
	@IsString()
	brandId: string;

	@IsOptional()
	@IsString()
	categoryId: string;

	@IsOptional()
	@IsEnum(DefaultStatus)
	status: DefaultStatus

}


export class BrandCategoryProductDto {
	brandId: string;
	limit?: number = 5;
	userRoles: UserRole;
}


export class PaginationWithFilterDto {
	@IsOptional()
	@Type(() => Number)
	limit: number = 5;

	@IsOptional()
	@Type(() => Number)
	offset: number = 0;

	@IsOptional()
	@IsString()
	keyword: string;

	@IsOptional()
	@IsEnum(ProductStatus)
	status: ProductStatus;

	@IsOptional()
	@Type(() => Number)
	minPrice: number;

	@IsOptional()
	@Type(() => Number)
	maxPrice: number;

	@IsOptional()
	@Type(() => Number)
	minRating: number;

	@IsOptional()
	@Type(() => Number)
	maxRating: number;

	@IsOptional()
	sortBy: 'price' | 'rating' | 'createdAt';

	@IsOptional()
	sortOrder: 'ASC' | 'DESC';

	@IsOptional()
	color: string;

	@IsOptional()
	@IsString()
	brandId: string;

	@IsOptional()
	@IsString()
	userId: string;
}



