import { Column, Entity, OneToMany, PrimaryGeneratedColumn } from 'typeorm';
import { Category } from '../../category/entities/category.entity';
import { Product } from '../../product/entities/product.entity';
import { DefaultStatus } from 'src/enum';

@Entity()
export class Brand {
	@PrimaryGeneratedColumn('uuid')
	id: string;

	@Column({ type: 'varchar', length: 200, nullable: true })
	name: string;

	@Column({ type: 'text', nullable: true })
	image: string;

	@Column({ type: 'text', nullable: true })
	imageName: string;

	@Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.ACTIVE })
	status: DefaultStatus;

	@OneToMany(() => Product, product => product.brand)
	products: Product[];
}
