import { Account } from "src/account/entities/account.entity";
import { Cart } from "src/cart/entities/cart.entity";
import { Column, CreateDateColumn, Entity, ManyToOne, PrimaryGeneratedColumn, UpdateDateColumn } from "typeorm";
import { Product } from "src/product/entities/product.entity";
@Entity()
export class CartItem {

  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid' })
  cartId: string;

  @Column({ type: 'uuid', nullable: true })
  productId: string;


  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'int', default: 1 })
  quantity: number;

  @Column({ type: 'decimal', precision: 10, scale: 2 })
  price: number;

  @Column({ type: 'decimal', precision: 10, scale: 2 })
  subTotalPrice: number;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;
  @ManyToOne(() => Cart, (cart) => cart.cartItems, { onDelete: 'CASCADE' })
  cart: Cart;

  @ManyToOne(() => Product, (product) => product.cartItems, { onUpdate: 'CASCADE', onDelete: 'CASCADE', })
  product: Product;


  @ManyToOne(() => Account, (account) => account.cartItems, {
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

}
