import { Module } from '@nestjs/common';
import { CartService } from './cart.service';
import { CartController } from './cart.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Cart } from './entities/cart.entity';
import { AuthModule } from 'src/auth/auth.module';
import { CartItem } from 'src/cart-item/entities/cart-item.entity';
import { Product } from 'src/product/entities/product.entity';
import { Account } from 'src/account/entities/account.entity';
import { Coupon } from 'src/coupon/entities/coupon.entity';
import { UserCoupon } from 'src/coupon/entities/user-coupon.entity';
import { NotificationsModule } from 'src/notifications/notifications.module';


@Module({
  imports:[TypeOrmModule.forFeature([Cart,CartItem,Product,Account,Coupon,UserCoupon]),AuthModule,NotificationsModule],
  controllers: [CartController],
  providers: [CartService],
})
export class CartModule {}
