import { Account } from 'src/account/entities/account.entity';
import { CartItem } from 'src/cart-item/entities/cart-item.entity';
import { Product } from 'src/product/entities/product.entity';

import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  OneToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';
import { Coupon } from '../../coupon/entities/coupon.entity';
import { UserRole } from '../../enum';

@Entity()
export class Cart {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'enum', enum: UserRole,nullable:false })
  role: UserRole;

  @Column({ type: 'decimal', precision: 10, scale: 2 })
  totalPrice: number;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Account, (account) => account.cart, {
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => Product, (product) => product.cart, {
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  product: Product[];



  @OneToMany(() => CartItem, (cartItems) => cartItems.cart, {

  })
  cartItems: CartItem[];



  @Column({ type: 'uuid', nullable: true })
  couponId: string;

  @ManyToOne(() => Coupon, (coupon) => coupon.carts, {
    onDelete: 'SET NULL',
    nullable: true,
  })
  coupon: Coupon;


}
