import { Module } from '@nestjs/common';
import { MulterModule } from '@nestjs/platform-express';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { CategoryController } from './category.controller';
import { CategoryService } from './category.service';
import { Category } from './entities/category.entity';
import { Product } from '../product/entities/product.entity';
import { Brand } from '../brand/entities/brand.entity';
import { Wishlist } from '../wishlist/entities/wishlist.entity';


@Module({
  imports: [
    TypeOrmModule.forFeature([Category]),
      AuthModule
  ],
  providers: [CategoryService],
  controllers: [CategoryController],
  exports: [CategoryService],
})
export class CategoryModule { }
