import { ApiProperty } from '@nestjs/swagger';
import { Transform, Type } from 'class-transformer';
import {
  IsArray,
  IsBoolean,
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  IsUUID,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { YesNo } from 'src/enum';

export class CityDto {
  @ApiProperty()
  @IsNotEmpty()
  @IsString()
  @MinLength(4)
  @MaxLength(50)
  name: string;

  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  stateId: number;

  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  deliveryCharge: number;

  @IsOptional()
  @IsEnum(YesNo, { message: 'isCodAvailable must be YES or NO' })
  isCodAvailable: YesNo
}

export class UpdateCityDto {
  @ApiProperty()
  @IsOptional()
  @IsString()
  @MinLength(4)
  @MaxLength(50)
  name: string;

  @ApiProperty()
  @IsOptional()
  @Type(() => Number)
  @IsNumber()
  deliveryCharge: number;

  @IsOptional()
  @IsEnum(YesNo, { message: 'isCodAvailable must be YES or NO' })
  isCodAvailable: YesNo
}

export class PaginationSDto {
  @ApiProperty()
  @IsOptional()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(50)
  limit: number;

  @ApiProperty()
  @IsOptional()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @ApiProperty()
  @IsOptional()
  keyword: string;

  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  status: boolean;

  @IsOptional()
  @IsEnum(YesNo, { message: 'isCodAvailable must be YES or NO' })
  isCodAvailable: YesNo
}
