export class CreateCityDto { }
import { IsBoolean, IsNumber, IsOptional, IsString, Min } from 'class-validator';
import { Type } from 'class-transformer';

export class PaginationDto {
	@IsOptional()
	@Type(() => Number)
	@IsNumber()
	@Min(0)
	limit: number;

	@IsOptional()
	@Type(() => Number)
	@IsNumber()
	@Min(0)
	offset: number;

	@IsOptional()
	@IsString()
	keyword: string;

	@IsOptional()
	@Type(() => Boolean)
	@IsBoolean()
	status: boolean;

	@IsOptional()
	@Type(() => Number)
	@IsNumber()
	stateId: number;
}
