
import { deliveryAddress } from 'src/delivery-address/entities/delivery-address.entity';
import { State } from 'src/state/entities/state.entity';
import { YesNo } from 'src/enum';
import {
  Column,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
} from 'typeorm';

@Entity()
export class City {
  @PrimaryGeneratedColumn('increment')
  id: number;

  @Column({ type: 'varchar', length: 100, nullable: true })
  name: string;

  @Column({ type: 'boolean', default: true })
  status: boolean;

  @Column({ type: 'int', nullable: true })
  stateId: number;

  @Column({ type: 'int', nullable: true })
  deliveryCharge: number



  @Column({ type: 'enum', enum: YesNo, default: YesNo.NO })
  isCodAvailable: YesNo;


  @ManyToOne(() => State, (state) => state.city, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  state: State;



}
