import { Column, CreateDateColumn, Entity, PrimaryGeneratedColumn } from "typeorm";
import { IsPhoneNumber } from 'class-validator';

@Entity()
export class ContactUs {
    @PrimaryGeneratedColumn('uuid')
    id: string;

    @Column({type: 'varchar', length: 100, nullable: true})
    name: string;
    
    @Column({ type: 'varchar', length: 100, nullable: true })
    email: string;

     @Column({ type: 'varchar', length: 100, nullable: true })
    phoneNumber: string;
    
    @Column({type: 'text', nullable: true})
    subject: string;

    @Column({type: 'text', nullable: true})
    message: string;

    @CreateDateColumn()
    createdAt: Date;
}
