import { Controller, Get, Post, Body, Patch, Param, Delete, Query, UseGuards } from '@nestjs/common';
import { DashboardService } from './dashboard.service';
import { DefaultStatus, PermissionAction, UserRole } from 'src/enum';
import { AuthGuard } from '@nestjs/passport';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { PaginationSDto } from 'src/user-details/dto/update-user-details';
import { DefaultStatusDto } from 'src/common/dto/default-status.dto';
import { CurrentUser } from '../auth/decorators/current-user.decorator';
import { Account } from '../account/entities/account.entity';
import { PermissionsGuard } from 'src/auth/guards/permissions.guard';
import { CheckPermissions } from 'src/auth/decorators/permissions.decorator';

@Controller('dashboard')
export class DashboardController {
  constructor(private readonly dashboardService: DashboardService) { }

  @Get('notifications')
    @UseGuards(AuthGuard('jwt'), RolesGuard, PermissionsGuard)
  @Roles(UserRole.ADMIN,UserRole.STAFF)
     @CheckPermissions([PermissionAction.READ, 'dashboard'])
  GetNotifications(@Query() dto: PaginationSDto, @CurrentUser() user: Account) {
    return this.dashboardService.getAdminNotifications(user.id, dto.limit, dto.offset);
  }

  @Get('counts')
   @UseGuards(AuthGuard('jwt'), RolesGuard, PermissionsGuard)
  @Roles(UserRole.ADMIN,UserRole.STAFF)
      @CheckPermissions([PermissionAction.READ, 'dashboard'])
  getTotalCounts() {
    return this.dashboardService.getTotalCounts();
  }
}
