import { Injectable, NotFoundException } from '@nestjs/common';
import { DefaultStatus, NotificationType, ProductStatus, UserRole } from 'src/enum';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Account } from 'src/account/entities/account.entity';
import { Product } from 'src/product/entities/product.entity';
import { PaginationSDto } from 'src/user-details/dto/update-user-details';
import { DefaultStatusDto } from 'src/common/dto/default-status.dto';



@Injectable()
export class DashboardService {

  constructor(
    @InjectRepository(Account) private readonly accountRepo: Repository<Account>,
    @InjectRepository(Product) private readonly productRepo: Repository<Product>,
  ) { }

  async getAdminNotifications(accountIds: string, limit: number, offset: number) {
    const [result, total] = await this.accountRepo
      .createQueryBuilder('notification')
      .where('notification.accountId IN (:...accountIds)', { accountIds })
      .skip(offset)
      .take(limit)
      .orderBy('notification.createdAt', 'DESC')
      .getManyAndCount();

    return [result, total];
  }

  async getTotalCounts() {
    const query = this.accountRepo.createQueryBuilder('account');
    const productQuery = this.productRepo.createQueryBuilder('product');
    const userCount = await query
      .where('account.roles = :roles', { roles: UserRole.USER })
      .getCount();
    const retailerCount = await query
      .where('account.roles = :roles', { roles: UserRole.RETAILER })
      .getCount();

    const productCount = await productQuery
      .where('product.status = :status', { status: ProductStatus.IN_STOCK })
      .getCount();

    return {
      userCount,
      retailerCount,
      productCount,
    };
  }
}
