import { IsNotEmpty, IsOptional, IsString } from "class-validator";

export class CreateDeliveryDetailDto {

    @IsNotEmpty()
    @IsString()
    name: string;

    @IsNotEmpty()
    @IsString()
    address: string;


    @IsNotEmpty()
    @IsString()
    landMark: string;

    @IsNotEmpty()
    @IsString()
    state: string;

    @IsNotEmpty()
    @IsString()
    city: string;

    @IsNotEmpty()
    @IsString()
    pin: string;


    @IsNotEmpty()
    @IsString()
    phNumber: string;

    @IsOptional()
    isDefault: boolean;


}


