import { Account } from "src/account/entities/account.entity";
import { Order } from "src/order/entities/order.entity";
import { Column, Entity, ManyToOne, OneToMany, PrimaryGeneratedColumn } from "typeorm";

@Entity()
export class deliveryAddress {

  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  name: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  address: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  landMark: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  city: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  state: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  pin: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  phNumber: string;

  @Column({ default: true })
  isDefault: boolean;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @ManyToOne(() => Account, (account) => account.deliveryDetail, {
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account;

  @OneToMany(() => Order, (order) => order.deliveryAddress)
  orders: Order[];
}
