export enum UserRole {
  ADMIN = 'ADMIN',
  USER = 'USER',
  RETAILER = 'RETAILER',
  STAFF='STAFF'
}

export enum DefaultStatus {
  ACTIVE = 'ACTIVE',
  DEACTIVE = 'DEACTIVE',
  DELETED = 'DELETED',
  SUSPENDED = 'SUSPENDED',
  PENDING = 'PENDING',
}
export enum ProductStatus {
  INACTIVE = 'INACTIVE',
  IN_STOCK = 'IN_STOCK',
  OUT_OF_STOCK = 'OUT_OF_STOCK',
}

export enum CategoryType {
  TRENDING = 'TRANDING',
  NORMAL = 'NORMAL',
}

export enum BannerType {
  HOME = 'HOME',
  CATEGORY = 'CATEGORY',
  PRODUCT = 'PRODUCT',
  BRAND = 'BRAND',
}

export enum OrderStatus {
  PENDING_PAYMENT = 'PENDING_PAYMENT',
  PLACED = 'PLACED',
  SHIPPED = 'SHIPPED',
  COMPLETED = 'COMPLETED',
  DELIVERED = 'DELIVERED',
  CANCELED = 'CANCELED',
  RETURN_REQUESTED = 'RETURN_REQUESTED',
  RETURN_APPROVED = 'RETURN_APPROVED',
  REFUNDED = 'REFUNDED'
}

export enum PaymentMethod {
  COD = 'COD',
  ONLINE = 'ONLINE'
}
export enum PageType {
  TNC = 'TERMS & CONDITIONS',
  PRIVACY_POLICY = 'PRIVACY POLICY',
}

export enum DiscountType {
  PERCENTAGE = 'PERCENTAGE',
  FLAT = 'FLAT',
}

export enum CouponStatus {
  ACTIVE = 'ACTIVE',
  USED = 'USED',
  EXPIRED = 'EXPIRED',
}

export enum CategoryStatus {
  ACTIVE = 'ACTIVE',
  DEACTIVE = 'DEACTIVE',
  DELETED = 'DELETED'
}
export enum NotificationType {
  ORDER_PLACED = 'order_placed',
  PAYMENT_SUCCESS = 'payment_success',
  ORDER_STATUS_CHANGE = 'order_status_change',
  ORDER_CANCELLED = 'order_cancelled',
  CART_ABANDONMENT = 'cart_abandonment',
  CART_REMINDER = 'cart_reminder',
  PRICE_DROP = 'price_drop',
  NEW_PRODUCT = 'new_product',
  BACK_IN_STOCK = 'back_in_stock',
  PROMOTION = 'promotion',
  ACCOUNT = 'account',
  ACCOUNT_STATUS_CHANGE = 'account_status_change',
  SYSTEM = 'system',
  LOW_STOCK = 'low_stock',
  MANUAL = 'manual',
  RETURN_REQUESTED = 'return_requested',
  RETURN_APPROVED = 'return_approved',
  REFUND_PROCESSED = 'refund_processed'
}


export enum PaymentMode {
  CART = 'cart',
  DIRECT = 'direct',
}
export enum PermissionAction {
  CREATE = 'Create',
  READ = 'Read',
  UPDATE = 'Update',
  DELETE = 'Delete',
 
}
export enum YesNo {
  YES = 'YES',
  NO = 'NO',
}



