import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { NodeMailerService } from './node-mailer.service';
import { Setting } from 'src/settings/entities/setting.entity';
import { Account } from 'src/account/entities/account.entity';
import { MailerModule } from '@nestjs-modules/mailer';

@Module({
  imports: [
    TypeOrmModule.forFeature([Setting, Account]),
    MailerModule.forRootAsync({
      useFactory: () => ({
        transport: {
          host: process.env.RN_SMTP_HOST || 'smtp.gmail.com',
          port: parseInt(process.env.RN_SMTP_PORT || '587'),
          secure: process.env.RN_SMTP_SECURE === 'true',
          auth: {
            user: process.env.RN_SMTP_USER,
            pass: process.env.RN_SMTP_PASSWORD,
          },
          ignoreTLS: false,
          requireTLS: true,
        },
        defaults: {
          from: `"Notification" <${process.env.RN_SMTP_USER}>`,
        },
      }),
    }),
  ],
  providers: [NodeMailerService],
  exports: [NodeMailerService],
})
export class NodeMailerModule {}
