import { HttpModule } from '@nestjs/axios';
import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { Notification } from './entities/notification.entity';
import { CartItem } from '../cart-item/entities/cart-item.entity';
import { Product } from '../product/entities/product.entity';
import { NotificationsController } from './notifications.controller';
import { NotificationsService } from './notifications.service';
import { Wishlist } from '../wishlist/entities/wishlist.entity';
import { Account } from '../account/entities/account.entity';
import { NodeMailerModule } from 'src/node-mailer/node-mailer.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([Notification, CartItem, Product, Wishlist, Account]),  
    HttpModule.register({
      timeout: 5000,
      maxRedirects: 5,
    }),
    forwardRef(() => AuthModule), // Use forwardRef to avoid circular dependency
    NodeMailerModule,
  ],
  controllers: [NotificationsController],
  providers: [NotificationsService],
  exports: [NotificationsService],
})
export class NotificationsModule { }
