import { Order } from "src/order/entities/order.entity";
import { Product } from "src/product/entities/product.entity";
import { Column, Entity, ManyToMany, ManyToOne, OneToMany, PrimaryGeneratedColumn } from "typeorm";


@Entity()
export class OrderItem {
  @PrimaryGeneratedColumn('uuid')
  id: string;


  @Column({ type: 'int', default: 1 })
  quantity: number;

  @Column({ type: 'decimal', precision: 10, scale: 2 })
  price: number;

  @Column({ type: 'decimal', precision: 10, scale: 2 })
  totalPrice: number;

  @Column({ type: 'uuid', nullable: true })
  productId: string;
  @Column({ type: 'uuid', nullable: true })
  orderId: string;

  @ManyToOne(() => Product, (product) => product.oderItems)
  product: Product;


  @ManyToOne(() => Order, (order) => order.orderItems, { onUpdate: 'CASCADE', onDelete: 'CASCADE', })
  order: Order;

}



