import { Module } from '@nestjs/common';
import { OrderItemService } from './order-item.service';
import { OrderItemController } from './order-item.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Order } from 'src/order/entities/order.entity';
import { AuthModule } from 'src/auth/auth.module';
import { OrderItem } from './entities/order-item.entity';

@Module({
  imports:[TypeOrmModule.forFeature([OrderItem]),AuthModule],
  controllers: [OrderItemController],
  providers: [OrderItemService],
  exports:[OrderItemModule]
})
export class OrderItemModule {}
