import { IsArray, IsEnum, IsNotEmpty, IsNumber, IsOptional, IsString, IsUUID, ValidateNested } from 'class-validator';
import { Type } from 'class-transformer';
import { PaymentMethod, OrderStatus } from 'src/enum';

export class AdminCreateOrderDto {
  @IsUUID()
  @IsNotEmpty()
  userId: string;

  @IsUUID()
  @IsNotEmpty()
  productId: string;

  @IsNumber()
  @Type(() => Number)
  @IsOptional()
  quantity: number = 1;

  @IsNumber()
  @Type(() => Number)
  @IsNotEmpty()
  price: number;

  @IsNumber()
  @Type(() => Number)
  @IsNotEmpty()
  subTotal: number;

  @IsNumber()
  @Type(() => Number)
  @IsNotEmpty()
  gstAmount: number;

  @IsNumber()
  @Type(() => Number)
  @IsNotEmpty()
  totalAmount: number;

  @IsEnum(PaymentMethod)
  @IsNotEmpty()
  paymentMethod: PaymentMethod;

  @IsEnum(OrderStatus)
  @IsOptional()
  status: OrderStatus = OrderStatus.PLACED;

  @IsString()
  @IsNotEmpty()
  fullDeliveryAddress: string;

  @IsNumber()
  @Type(() => Number)
  @IsOptional()
  deliveryCharge: number = 0;
}