
import { IsArray, IsEnum, IsIn, IsNotEmpty, IsNumber, IsOptional, IsString, IsUUID, Max, Min, ValidateNested } from 'class-validator';
import { PaymentMethod, OrderStatus, PaymentMode, DefaultStatus } from 'src/enum';
import { Type } from 'class-transformer';
import { CreateOrderItemDto } from 'src/order-item/dto/order-item.dto';

export class CreateOrderDto {
  @IsUUID()
  @IsOptional()
  accountId: string;

  @IsNumber()
  @Type(() => Number)
  @IsOptional()
  gstAmount: number;

  @IsNumber()
  @Type(() => Number)
  @IsOptional()
  subTotal: number;

  @IsOptional()
  @IsNumber()
  @Type(() => Number)
  totalAmount: number;

  @IsEnum(PaymentMethod)
  @IsNotEmpty()
  paymentMethod: PaymentMethod;

  @IsEnum(OrderStatus)
  @IsOptional()
  status: OrderStatus;

  @IsUUID()
  @IsOptional()
  deliveryAddressId: string;
}

export class VerifyPaymentDto {
  @IsString()
  razorpayOrderId: string;

  @IsString()
  razorpayPaymentId: string;

  @IsString()
  razorpaySignature: string;

  @IsOptional()
  @IsString()
  paymentToken: string;

  @IsOptional()
  @IsString()
  productId: string;

  @IsOptional()
  mode: PaymentMode;

  @IsOptional()
  quantity: number;
}

export class StatusDto {
  @IsNotEmpty()
  @IsEnum(OrderStatus)
  status: OrderStatus;
}
export class DirectBuyDto {
  @IsUUID()
  @IsOptional()
  accountId: string;

  @IsUUID()
  @IsNotEmpty()
  productId: string;

  @IsOptional()
  quantity: number;

  @IsEnum(PaymentMethod)
  @IsNotEmpty()
  paymentMethod: PaymentMethod;

  @IsUUID()
  @IsOptional()
  deliveryAddressId: string;
}

export class OrderPricePreviewDto {
  @IsUUID()
  @IsNotEmpty()
  productId: string;

  @IsOptional()
  quantity: number;

}

export class PaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(1)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsString()
  @IsOptional()
  keyword: string;

  @IsOptional()
  @IsEnum(OrderStatus)
  status: OrderStatus;

  @IsOptional()
  @IsString()
  date: string;
}


