import { Account } from "src/account/entities/account.entity";
import { OrderStatus, PaymentMethod, } from "src/enum";
import { OrderItem } from "src/order-item/entities/order-item.entity";
import { deliveryAddress } from "src/delivery-address/entities/delivery-address.entity";
import { Column, CreateDateColumn, Entity, JoinColumn, ManyToOne, OneToMany, PrimaryGeneratedColumn, UpdateDateColumn } from "typeorm";
import { text } from 'stream/consumers';

@Entity()
export class Order {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'int', default: 1 })
  quantity: number;

  @Column({ type: 'decimal', precision: 10, scale: 2, nullable: true })
  gstAmount: number;

  @Column({ type: 'decimal', precision: 10, scale: 2, nullable: true })
  subTotal: number;

  @Column({ type: 'decimal', precision: 10, scale: 2 })
  totalAmount: number;

  @Column('decimal', { precision: 10, scale: 2, default: 0 })
  deliveryCharge: number;

  @Column({ type: 'enum', enum: PaymentMethod, default: PaymentMethod.COD })
  paymentMethod: PaymentMethod;

  @Column({ type: 'enum', enum: OrderStatus, default: OrderStatus.PLACED })
  status: OrderStatus;

  @Column({ type: 'varchar', length: 255, nullable: true })
  razorpayOrderId: string;

  @Column({ type: 'varchar', length: 255, nullable: true })
  razorpayPaymentId: string;

  @Column({ type: 'uuid', nullable: true })
  deliveryAddressId: string;

  @Column({ type: 'text', nullable: true })
  fullDeliveryAddress: string;

  @Column({ type: 'text', nullable: true })
  estimatedDeliveryDate: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @OneToMany(() => OrderItem, (orderItem) => orderItem.order)
  orderItems: OrderItem[];

  @ManyToOne(() => Account, (account) => account.order, {
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

@ManyToOne(() => deliveryAddress, (deliveryAddress) => deliveryAddress.orders, {
  onDelete: 'SET NULL',
})
  deliveryAddress: deliveryAddress;
}

