
import { Module } from '@nestjs/common';
import { OrderService } from './order.service';
import { OrderController } from './order.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Order } from './entities/order.entity';
import { Account } from 'src/account/entities/account.entity';
import { Cart } from 'src/cart/entities/cart.entity';
import { CartItem } from 'src/cart-item/entities/cart-item.entity';
import { OrderItem } from 'src/order-item/entities/order-item.entity';
import { CartItemModule } from 'src/cart-item/cart-item.module';
import { Product } from 'src/product/entities/product.entity';
import { ProductImage } from 'src/product-images/entities/product-image.entity';
import { NotificationsModule } from 'src/notifications/notifications.module';
import { Notification } from 'src/notifications/entities/notification.entity';
import { Wishlist } from 'src/wishlist/entities/wishlist.entity';
import { deliveryAddress } from 'src/delivery-address/entities/delivery-address.entity';
import { DeliveryAddressModule } from 'src/delivery-address/delivery-address.module';
import { UserDetail } from '../user-details/entities/user-detail.entity';
import { UserDetailsModule } from '../user-details/user-details.module';
import { Setting } from '../settings/entities/setting.entity';
import { SettingsModule } from '../settings/settings.module';
import { AuthModule } from 'src/auth/auth.module';
import { City } from 'src/city/entities/city.entity';
import { NodeMailerModule } from 'src/node-mailer/node-mailer.module';
import { CityModule } from 'src/city/city.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([Order, Account, Cart, CartItem, OrderItem, Product, Notification, deliveryAddress, UserDetail, Setting, City]),
    NotificationsModule,
    DeliveryAddressModule,
    SettingsModule,
    AuthModule,
    NodeMailerModule,
    CityModule
  ],
  controllers: [OrderController],
  providers: [OrderService],
  exports: [OrderService]
})
export class OrderModule { }

