import {
  IsString,
  IsNotEmpty,
  IsOptional,
  IsNumber,
  IsUUID,
  Min,
  Max,
  IsEnum,
  IsUrl,
  IsDecimal,
  IsBoolean,
} from 'class-validator';
import { ProductStatus } from '../../enum';


export class CreateProductDto {
  @IsString()
  categoryId: string;

  @IsString()
  brandId: string;

  @IsString()
  name: string;

  @IsString()
  description: string;

  @IsNumber()
  price: number;

  @IsNumber()
  quantity: number;

  @IsOptional()
  @IsEnum(ProductStatus)
  status: ProductStatus;

  @IsOptional()
  @IsString()
  color: string;

  @IsOptional()
  @IsNumber()
  userPrice: number;

  @IsOptional()
  @IsNumber()
  userDiscount: number;

  @IsOptional()
  @IsNumber()
  retailerDiscount: number;

  @IsOptional()
  @IsNumber()
  retailerPrice: number;

  @IsOptional()
  @IsDecimal()
  rating: number;

  @IsOptional()
  @IsNumber()
  reviewCount: number;

  @IsOptional()
  @IsString()
  highlights: string;

  @IsOptional()
  @IsString()
  replacement: string;

  @IsOptional()
  @IsBoolean()
  isCrazyDeal: boolean;

  @IsOptional()
  @IsBoolean()
  isHotDeals: boolean;
}
