import { IsOptional, IsString, IsInt, Min, Max, IsUUID, IsBoolean, IsEnum } from 'class-validator';
import { Transform, Type } from 'class-transformer';
import { ProductStatus } from '../../enum';

export class ProductPaginationDto {
  @IsOptional()
  @Type(() => Number)
  @IsInt()
  @Min(1)
  limit: number = 10;

  @IsOptional()
  @Type(() => Number)
  @IsInt()
  @Min(0)
  offset: number = 0;

  @IsOptional()
  @IsString()
  keyword: string;

  @IsOptional()
  @IsUUID()
  categoryId: string;

  @IsOptional()
  @IsUUID()
  brandId: string;

  @IsOptional()
  @IsUUID()
  productId: string;

  @IsOptional()
  @IsEnum(ProductStatus)
  status: ProductStatus;

  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  ratingAbove4: boolean;

  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  discountAbove15: boolean;

  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  priceLowToHigh: boolean;

  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  priceHighToLow: boolean;

  @IsOptional()
  @Transform(({ value }) => value === 'true')
  @IsBoolean()
  inStockOnly: boolean;

  @IsOptional()
  @Type(() => Boolean)
  @IsBoolean()
  hotDeals: boolean;

  @IsOptional()
  @Type(() => Boolean)
  @IsBoolean()
  crezyDeal: boolean;


}


