import {
  IsEnum,
  IsNumber,
  IsString,
  IsUUID,
  IsBoolean,
  IsOptional,
} from 'class-validator';
import { ProductStatus } from '../../enum';

export class UpdateProductDto {
  @IsOptional()
  @IsUUID()
  categoryId: string;

  @IsOptional()
  @IsUUID()
  brandId: string;

  @IsOptional()
  @IsString()
  name: string;

  @IsOptional()
  @IsString()
  description: string;

  @IsOptional()
  @IsNumber()
  price: number;

  @IsOptional()
  @IsNumber()
  quantity: number;

  @IsOptional()
  @IsEnum(ProductStatus)
  status: ProductStatus;

  @IsOptional()
  @IsString()
  color: string;

  @IsOptional()
  @IsNumber()
  userPrice: number;

  @IsOptional()
  @IsNumber()
  userDiscount: number;

  @IsOptional()
  @IsNumber()
  retailerDiscount: number;

  @IsOptional()
  @IsNumber()
  retailerPrice: number;

  @IsOptional()
  @IsNumber()
  rating: number;

  @IsOptional()
  @IsNumber()
  reviewCount: number;

  @IsOptional()
  @IsString()
  highlights: string;

  @IsOptional()
  @IsBoolean()
  isCrazyDeal: boolean;

  @IsOptional()
  @IsBoolean()
  isHotDeals: boolean;
}

export class UpdateProductStatusDto {
  @IsEnum(ProductStatus)
  status: ProductStatus;
}

