import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';
import { Category } from '../../category/entities/category.entity';
import { ProductStatus } from '../../enum';
import { Brand } from '../../brand/entities/brand.entity';
import { ProductImage } from 'src/product-images/entities/product-image.entity';
import { Wishlist } from 'src/wishlist/entities/wishlist.entity';
import { Cart } from 'src/cart/entities/cart.entity';
import { CartItem } from 'src/cart-item/entities/cart-item.entity';
import { OrderItem } from 'src/order-item/entities/order-item.entity';
import { RatingFeedback } from 'src/rating-feedback/entities/rating-feedback.entity';


@Entity()
export class Product {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: false })
  categoryId: string;

  @Column({ type: 'uuid', nullable: false })
  brandId: string;

  @Column({ type: 'varchar', length: 200, nullable: true })
  name: string;

  @Column({ type: 'text', nullable: true })
  description: string;

  @Column({ type: 'decimal', precision: 10, scale: 2 })
  price: number;

  @Column({ nullable: true })
  quantity: number;

  @Column({
    type: 'enum',
    enum: ProductStatus,
    default: ProductStatus.IN_STOCK,
    nullable: true,
  })
  status: ProductStatus;

  @Column({ type: 'varchar', length: 100, nullable: true })
  color: string;

  @Column({ type: 'decimal', precision: 10, scale: 2, nullable: true })
  userPrice: number;

  @Column({ type: 'int',default:0,})
  userDiscount: number;

  @Column({ type: 'int', default:0,  })
  retailerDiscount: number;

  @Column({ type: 'decimal', precision: 10, scale: 2, nullable: true })
  retailerPrice: number;

  @Column({ type: 'decimal', nullable: true, default: 3.5 })
  rating: number;

  @Column({ nullable: true })
  reviewCount: number;

  @Column({ type: 'varchar', length: 100, default: "7 days replacement", nullable: true })
  replacement: string;

  @Column({ type: 'text', nullable: true })
  highlights: string;

  @Column({ nullable: true })
  imageUrl: string;

  @Column({ nullable: true })
  imagePath: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Category, (category) => category.products, {
    onDelete: 'RESTRICT',
  })
  category: Category;

  @ManyToOne(() => Brand, (brand) => brand.products, {
    onDelete: 'RESTRICT',
  })
  brand: Brand; 

  @Column({ default: false })
  isCrazyDeal: boolean;

  @Column({ default: false })
  isHotDeals: boolean;

  @OneToMany(() => ProductImage, (productImage) => productImage.product)
  productImage: ProductImage[];

  @OneToMany(() => Wishlist, (wishlist) => wishlist.product)
  wishlist: Wishlist[];

  @OneToMany(() => Cart, (cart) => cart.product)
  cart: Cart[];

  @OneToMany(() => CartItem, (cartItems) => cartItems.product, { cascade: true, })
  cartItems: CartItem[];

  @OneToMany(() => OrderItem, (oderItems) => oderItems.product,)
  oderItems: OrderItem[];

  @OneToMany(() => RatingFeedback, (ratingFeedback) => ratingFeedback.product)
  ratingFeedback: RatingFeedback[];
}
