import { Module } from '@nestjs/common';
import { ProductService } from './product.service';
import { ProductController } from './product.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Product } from './entities/product.entity';
import { Category } from '../category/entities/category.entity';
import { Brand } from '../brand/entities/brand.entity';
import { ProductImage } from 'src/product-images/entities/product-image.entity';
import { ProductImagesModule } from 'src/product-images/product-images.module';
import { Account } from '../account/entities/account.entity';
import { Wishlist } from '../wishlist/entities/wishlist.entity';
import { AuthModule } from 'src/auth/auth.module';

@Module({
  imports: [TypeOrmModule.forFeature([Product, Category, Brand, ProductImage]), AuthModule,ProductImagesModule],
  controllers: [ProductController],
  providers: [ProductService],
  exports: [ProductService],
})
export class ProductModule { }
