import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import {
  IsBoolean,
  IsDecimal,
  IsInt,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  IsUUID,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';

export class RatingFeedbackDto {


  @IsUUID()
  productId: string;



  @IsOptional()
  @IsString()
  feedback: string;


  @IsNotEmpty()
@Type(() => Number)
@IsNumber({}, { message: 'Rating must be a number between 1 and 5' })
@Min(1)
@Max(5)
rating: number;



  @ApiProperty()
  @IsOptional()
  @IsUUID()
  accountId: string;
}

export class FeedbackPaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(1)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  @IsBoolean()
  status: boolean;


  @IsOptional()
  productId: string
}
