import { IsBoolean, IsOptional } from 'class-validator';
import { Account } from 'src/account/entities/account.entity';
import { Product } from 'src/product/entities/product.entity';
import {

  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class RatingFeedback {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'text', nullable: true })
  feedback: string;

  @Column({ type: 'decimal', nullable: true, precision: 2, scale: 1, default: 0.0 })
  rating: number;;

  @Column({ type: 'boolean', default: false })
  status: boolean;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'uuid', nullable: true })
  productId: string;

 @ManyToOne(() => Product, (product) => product.ratingFeedback, {
  onDelete: 'CASCADE',
})
  product: Product;


  @ManyToOne(() => Account, (account) => account.ratingFeedback, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];


}
