import { Controller, Get, Post, Body, Patch, Param, Delete,Put ,NotFoundException, UseGuards, Query} from '@nestjs/common';
import { StaffDetailService } from './staff_detail.service';
import { UpdateStaffDetailDto } from './dto/update-staff_detail.dto';
import { StaffDetail } from './entities/staff_detail.entity';
import { AuthGuard } from '@nestjs/passport';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { UserRole } from 'src/enum';
import { PaginationDto } from 'src/account/dto/account.dto';
import { CurrentUser } from 'src/auth/decorators/current-user.decorator';
import { Account } from 'src/account/entities/account.entity';



@Controller('staff-detail')
export class StaffDetailController {
  constructor(private readonly staffService: StaffDetailService) {}


  @Get()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  findAll(@Query() dto: PaginationDto) {
    return this.staffService.findAll(dto);
  }

  
 @Get('profile')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(...Object.values(UserRole))
  profile(@CurrentUser() user: Account) {
    return this.staffService.getProfile(user.id);
  }

  @Patch()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.STAFF)
  update(@CurrentUser() user: Account, @Body() dto:UpdateStaffDetailDto) {
    return this.staffService.update(user.id, dto);
  }
  @Delete(':id')
  async deleteStaff(@Param() id: string) {
    const deleted = await this.staffService.deleteStaff(id);
    if (!deleted) {
      throw new NotFoundException(`Staff with ID ${id} not found`);
    }
    return { message: 'Staff deleted successfully' };
  }

}
