import { Type } from 'class-transformer';
import {
  IsString,
  MinLength,
  MaxLength,
  IsOptional,
  IsNotEmpty,
  IsNumber,
  Max,
  Min,
  IsEnum,
} from 'class-validator';
import { DefaultStatusDto } from '../../common/dto/default-status.dto';

export class UpdateUserDetailDto {
  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(50)
  name: string;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(50)
  email: string;


  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(50)
  alternativePhoneNumber: string;
}

export class PaginationSDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(50)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  keyword: string;


  @IsOptional()
  status:DefaultStatusDto;
}


export class SaveProfileDto {
  @IsString()
  @IsOptional()
  profile_image: string;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(50)
  name: string;
  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(50)
  email: string;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(50)
  alternativePhoneNumber: string;

  @IsOptional()
  accountId: string;
}
