import axios from 'axios';
export async function sendOtpReg(
  phoneNumber: string,
  otp: number,
): Promise<boolean> {
  try {
    const baseUrl = 'http://axonsms.com/api/mt/SendSMS';
    const params = new URLSearchParams({
      APIKey: process.env.RN_OTP_API_KEY,
      senderid: process.env.RN_OTP_SENDERID,
      channel: '2',
      DCS: '0',
      flashsms: '0',
      number: phoneNumber,
      text: `Use this OTP ${otp} for registration. - BUDCEO	`,
      route: process.env.RN_SMS_ROUTE,
    });

    const response = await fetch(`${baseUrl}?${params.toString()}`);
    if (!response.ok) {
      return false;
    }
    return true;
  } catch (error) {
    return false;
  }
}
export async function sendSMS(phone: number, message: string) {
  try {
    const baseUrl = 'http://axonsms.com/api/mt/SendSMS';
    const params = new URLSearchParams({
      APIKey: process.env.RN_OTP_API_KEY,
      senderid: process.env.RN_OTP_SENDERID,
      channel: '2',
      DCS: '0',
      flashsms: '0',
      number: phone.toString(),
      text: message,
      route: process.env.RN_SMS_ROUTE || '1',
    });
    const response = await fetch(`${baseUrl}?${params.toString()}`);
    if (!response.ok) {
      console.error(`SMS API returned status: ${response.status}`);
      return false;
    }
    const responseData = await response.text();
    console.log('Axon SMS Response:', responseData);
    return true;
  } catch (error) {
    console.error('SMS sending failed:', error);
    return false;
  }
}
