import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { IsNotEmpty,   IsNumber,   IsOptional,   IsUUID, Max, Min } from 'class-validator';

export class CreateWishlistDto {
  @ApiProperty()
  @IsNotEmpty()
  @IsUUID()
  productId: string;


  @ApiProperty()
 @IsOptional()
  @IsUUID()
  accountId: string;


}
export class PaginationPDto {
  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(1)
  @Max(50)
  limit: number;

  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @ApiProperty()
  @IsOptional()
  keyword: string;
}
